<!DOCTYPE HTML>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ativar / Renovar</title>

    <style>
        body {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: flex-start;
            min-height: 100vh;
            margin: 0;
            padding-top: 50px; /* Margem superior */
            background-color: #2c3e50; /* Cor de fundo mais moderna */
            color: #ecf0f1; /* Cor do texto clara */
            font-family: 'Arial', sans-serif;
            overflow-y: auto; /* Habilita a barra de rolagem */
        }

        h1 {
            text-align: center;
            animation: blinkText 1.5s infinite alternate;
            color: #e74c3c; /* Cor vibrante para o título */
            margin-bottom: 20px;
        }

        @keyframes blinkText {
            0% { color: #ecf0f1; }
            50% { color: #e74c3c; }
            100% { color: #ecf0f1; }
        }

        .box {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin: 20px 0;
            background-color: #34495e; /* Cor de fundo mais escura para os cartões */
            padding: 20px;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
        }

        .box img {
            width: 200px;
            height: 200px;
            border-radius: 10px;
            animation: blinkImage 1s infinite alternate;
            margin-bottom: 15px;
        }

        @keyframes blinkImage {
            0% { opacity: 1; }
            50% { opacity: 0.7; }
            100% { opacity: 1; }
        }

        .message {
            text-align: center;
            font-size: 18px;
            margin-bottom: 20px;
            color: #f39c12; /* Cor de destaque amarela */
        }

        .button {
            margin-top: 20px;
            padding: 12px 25px;
            background-color: #e67e22; /* Cor laranja para o botão */
            color: #ffffff;
            font-size: 16px;
            font-weight: bold;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            text-align: center;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            transition: background-color 0.3s, transform 0.2s;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .button:hover {
            background-color: #d35400; /* Cor mais escura para o hover */
        }

        .button:active {
            transform: scale(0.98);
        }

        .desktop-only {
            display: none;
            margin-top: 10px;
            color: #f39c12;
            font-size: 14px;
            text-align: center;
        }

        @media (min-width: 769px) {
            .desktop-only {
                display: block;
            }
        }
    </style>
</head>
<body>

    <h1>Escaneie o QR Code para Ativar seu Acesso!</h1>
    
    <div class="message">
        Para pagar/renovar, basta ler o QR Code abaixo e acessar nossos planos.
    </div>
    <div class="box">
        <img id="qrCode" alt="QR Code">
    </div>
    
    <script>
        // Função para ler o arquivo qrcode.txt e gerar o QR Code
        fetch('../qrcode.txt')
            .then(response => response.text())
            .then(data => {
                // Remover espaços em branco
                const paymentLink = data.trim();
                
                // Gera o URL para o QR Code
                const qrCodeUrl = `https://image-charts.com/chart?chs=500x500&cht=qr&chl=${encodeURIComponent(paymentLink)}`;
                
                // Define o link gerado dinamicamente para o QR Code
                document.getElementById("qrCode").src = qrCodeUrl;

                // Armazena o link de pagamento para cópia
                window.paymentLink = paymentLink;
            })
            .catch(error => {
                console.error('Erro ao ler o arquivo:', error);
            });

        // Função para copiar o link de pagamento
        function copyPaymentLink() {
            navigator.clipboard.writeText(window.paymentLink).then(() => {
                alert("Link de pagamento copiado com sucesso! Cole no navegador do seu dispositivo para prosseguir.");
            }).catch(() => {
                alert("Desculpe, não foi possível copiar o link. Tente copiar manualmente.");
            });
        }
    </script>

</body>
</html>
